/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.resources;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;
import org2.eclipse.php.internal.debug.core.resources.ExternalFileWrapper;
import org2.eclipse.php.internal.debug.core.resources.ExternalFilesRegistryListener;

public class ExternalFilesRegistry {
    private static final ExternalFilesRegistry instance = new ExternalFilesRegistry();
    private final HashMap<String, IFile> externalFilesRegistry = new HashMap();
    private final ListenerList listeners = new ListenerList();
    private IProject externalFilesProject = ResourcesPlugin.getWorkspace().getRoot().getProject("external_" + System.currentTimeMillis());

    private ExternalFilesRegistry() {
    }

    public static ExternalFilesRegistry getInstance() {
        return instance;
    }

    public synchronized void addFileEntry(String localPath, IFile externalFile) {
        if (!this.externalFilesRegistry.containsKey(localPath)) {
            this.externalFilesRegistry.put(localPath, externalFile);
            this.notifyEntryChange(localPath, true);
        }
    }

    public IFile getFileEntry(String localPath) {
        return this.externalFilesRegistry.get(localPath);
    }

    public synchronized void removeFileEntry(String localPath) {
        if (this.externalFilesRegistry.remove(localPath) != null) {
            this.notifyEntryChange(localPath, false);
        }
    }

    private void notifyEntryChange(String localPath, boolean isAddition) {
        Object[] listenersList = this.listeners.getListeners();
        int i = 0;
        while (i < listenersList.length) {
            if (isAddition) {
                ((ExternalFilesRegistryListener)listenersList[i]).externalFileAdded(localPath);
            } else {
                ((ExternalFilesRegistryListener)listenersList[i]).externalFileRemoved(localPath);
            }
            ++i;
        }
    }

    public boolean isEntryExist(String localPath) {
        if (this.externalFilesRegistry.containsKey(localPath)) {
            return true;
        }
        Collection<IFile> coll = this.externalFilesRegistry.values();
        for (IFile iFile : coll) {
            if (!iFile.getFullPath().equals((Object)new Path(localPath))) continue;
            return true;
        }
        return false;
    }

    public boolean isEntryExist(IFile file) {
        if (file == null) {
            return false;
        }
        Collection<IFile> coll = this.externalFilesRegistry.values();
        for (IFile iFile : coll) {
            if (!iFile.getFullPath().toOSString().equals(file.getFullPath().toOSString())) continue;
            return true;
        }
        return false;
    }

    public void addListener(ExternalFilesRegistryListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ExternalFilesRegistryListener listener) {
        this.listeners.remove((Object)listener);
    }

    public IFile[] getAllAsIFiles() {
        Collection<IFile> coll = this.externalFilesRegistry.values();
        IFile[] result = new ExternalFileWrapper[coll.size()];
        coll.toArray(result);
        return result;
    }

    public IProject getExternalFilesProject() {
        return this.externalFilesProject;
    }
}

